# Run scripts to create "year list" files for alternate scenarios

# Master package loading ----------------------------------------------------------

source("./R scripts/Master package loading.R", encoding="ISO-8859-1")



# Base scenario starting cohort pathways ----------------------------------

rm(list=ls())

starting_cohorts_pathways_file <- "./Output data/starting_cohorts_pathways_20211026.qs"


## convergence in rate of returns
converge_rate <- 0.04
converge_years <- 10



# Rate of return adjustments -------------------------------------

# (All scenarios implemented in cohort sim step 5 R script)



# Wealth transfer adjustments ----------------------------------------------------

# 2a: Wealthy receive larger inheritances
# (Implemented in cohort sim step 5 R script)

# 2b: Wealthy save more of inheritance
source("./R scripts/Data and parameters/Scenario adjustments/2b Wealthy save more of inheritance.R")

# 2c: Less wealthy save less before receiving inheritance
# (Implemented in 'source for n and wealth' script)

# 2d: Older cohorts save more of inheritance
source("./R scripts/Data and parameters/Scenario adjustments/2d Older cohorts save more of inheritance.R")

# 2e: Save 80 per cent of inheritances
# (Implemented in cohort sim step 5 R script)

# 2f: Housing for gifts
# (Implemented in cohort sim step 5 R script)



# Housing adjustments ------------------------------


# 3a: Alternate method for estimating probability of homeownership
source("./R scripts/Data and parameters/Scenario adjustments/3a Alternate method for estimating probability of homeownership.R")


# 3b: Housing debt to asset ratio on purchase is 83 per cent
# (Implemented in cohort sim step 5 R script)


# 3c: Same housing entry price across all income groups
source("./R scripts/Data and parameters/Scenario adjustments/3c Same housing entry price across all income groups.R")


# 3d: Housing entry prices increase over time
source("./R scripts/Data and parameters/Scenario adjustments/3d Housing entry prices increase over time.R")


# 3e: Housing affordability declines over time
source("./R scripts/Data and parameters/Scenario adjustments/3e Housing affordability declines over time.R")


# 3f: Lower housing demand
source("./R scripts/Data and parameters/Scenario adjustments/3f Lower housing demand.R")



# Other adjustments ----------------------------------------------------

# 4a: Alternate method for estimating drawdowns in other assets
source("./R scripts/Data and parameters/Scenario adjustments/4a Alt method for estimating drawdowns in other assets.R")


# 4b: Older cohorts’ drawdowns from wealth increase over time
source("./R scripts/Data and parameters/Scenario adjustments/4b Older cohorts drawdowns from wealth increase over time.R")

# 4c: All wealth to younger generations at death
# (Implemented in cohort sim step 5 R script)